/*
 * Decompiled with CFR 0.152.
 */
package org.waxeye.ast;

import java.util.List;
import org.waxeye.ast.IAST;
import org.waxeye.ast.IASTVisitor;
import org.waxeye.ast.IChar;
import org.waxeye.ast.Position;
import org.waxeye.ast.print.ArrowPrinter;

public final class AST<E extends Enum<?>>
implements IAST<E> {
    private final E type;
    private final List<IAST<E>> children;
    private final Position position;

    public AST(E type, List<IAST<E>> children, Position position) {
        this.type = type;
        this.children = children;
        this.position = position;
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (this.type != null);
        assert (this.children != null);
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            AST p = (AST)object;
            if (((Enum)this.type).equals(p.type) && this.children.equals(p.children)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int start = 17;
        int mult = 37;
        int result = 17 * ((Enum)this.type).hashCode();
        for (IAST<E> t : this.children) {
            result = 37 * result + t.hashCode();
        }
        return Math.abs(result);
    }

    @Override
    public List<IAST<E>> getChildren() {
        return this.children;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public E getType() {
        return this.type;
    }

    @Override
    public void acceptASTVisitor(IASTVisitor visitor) {
        visitor.visitAST(this);
    }

    @Override
    public String childrenAsString() {
        StringBuilder buf = new StringBuilder();
        for (IAST<E> c : this.children) {
            buf.append(((IChar)((Object)c)).getValue());
        }
        return buf.toString();
    }

    public String toString() {
        return new ArrowPrinter(this).toString();
    }
}

