/*
 * Decompiled with CFR 0.152.
 */
package org.waxeye.ast.print;

import org.waxeye.ast.IAST;
import org.waxeye.ast.IASTVisitor;
import org.waxeye.ast.IChar;
import org.waxeye.ast.IEmpty;
import org.waxeye.ast.IString;

public final class ArrowPrinter
implements IASTVisitor {
    private StringBuilder buf = new StringBuilder();
    private int indentLevel = 0;

    public ArrowPrinter(IAST<?> tree) {
        tree.acceptASTVisitor(this);
    }

    @Override
    public void visitAST(IAST<?> tree) {
        for (int i = 1; i < this.indentLevel; ++i) {
            this.buf.append("    ");
        }
        if (this.indentLevel > 0) {
            this.buf.append("->  ");
        }
        this.buf.append(tree.getType());
        ++this.indentLevel;
        for (IAST<?> child : tree.getChildren()) {
            this.buf.append("\n");
            child.acceptASTVisitor(this);
        }
        --this.indentLevel;
    }

    @Override
    public void visitEmpty(IEmpty tree) {
    }

    @Override
    public void visitChar(IChar tree) {
        for (int i = 1; i < this.indentLevel; ++i) {
            this.buf.append("    ");
        }
        if (this.indentLevel > 0) {
            this.buf.append("|   ");
        }
        this.buf.append(tree.getValue());
    }

    @Override
    public void visitString(IString tree) {
        for (int i = 1; i < this.indentLevel; ++i) {
            this.buf.append("    ");
        }
        if (this.indentLevel > 0) {
            this.buf.append("|   ");
        }
        this.buf.append(tree.getValue());
    }

    public String toString() {
        return this.buf.toString();
    }
}

