/*
 * Decompiled with CFR 0.152.
 */
package org.waxeye.input;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;

public final class BufferFiller {
    private static final int FILLED_INIT = 128;
    private static final int BLOCK_SIZE = 1024;

    private BufferFiller() {
    }

    public static char[] asArray(InputStream input) {
        return BufferFiller.asArray(new InputStreamReader(input));
    }

    public static char[] asArray(Reader reader) {
        ArrayList<char[]> filled = new ArrayList<char[]>(128);
        char[] current = new char[1024];
        int currentIndex = 0;
        int resultSize = 0;
        try {
            int in = reader.read();
            while (in != -1) {
                if (currentIndex == 1024) {
                    filled.add(current);
                    current = new char[1024];
                    currentIndex = 0;
                }
                current[currentIndex] = (char)in;
                ++currentIndex;
                ++resultSize;
                in = reader.read();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        char[] result = new char[resultSize];
        int resultIndex = 0;
        for (char[] block : filled) {
            System.arraycopy(block, 0, result, resultIndex, 1024);
            resultIndex += 1024;
        }
        System.arraycopy(current, 0, result, resultIndex, currentIndex);
        return result;
    }
}

