/*
 * Decompiled with CFR 0.152.
 */
package org.waxeye.parser;

import org.waxeye.ast.IAST;
import org.waxeye.parser.CharTransition;
import org.waxeye.parser.ITransition;
import org.waxeye.parser.ITransitionVisitor;

public class RegexTransition<E extends Enum<?>>
implements ITransition<E> {
    private final int frequency;
    private final CharTransition<E> charTransition;

    public RegexTransition(int frequency, char[] single, char[] min, char[] max) {
        this(frequency, new CharTransition(single, min, max));
    }

    public RegexTransition(int frequency, CharTransition<E> charTransition) {
        this.frequency = frequency;
        this.charTransition = charTransition;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean matches(String string) {
        if (string.length() != this.frequency) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (this.charTransition.withinSet(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IAST<E> acceptVisitor(ITransitionVisitor<E> visitor) {
        return visitor.visitRegexTransition(this);
    }
}

