/*
 * Decompiled with CFR 0.152.
 */
package org.waxeye.input;

import java.util.Arrays;
import org.waxeye.input.IParserInput;

public final class InputBuffer
implements IParserInput {
    private final char[] input;
    private int position;
    private final int inputSize;

    public InputBuffer(char[] input) {
        this.input = input;
        this.position = 0;
        this.inputSize = input.length;
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (this.input != null);
        assert (this.position >= 0 && this.position <= this.inputSize);
        return true;
    }

    @Override
    public int consume() {
        if (this.position < this.inputSize) {
            return this.input[this.position++];
        }
        return -1;
    }

    @Override
    public String consume(int length) {
        if (this.position + length - 1 < this.inputSize) {
            char[] result = new char[length];
            for (int i = 0; i < length; ++i) {
                result[i] = (char)this.consume();
            }
            return new String(result);
        }
        return null;
    }

    @Override
    public int peek() {
        if (this.position < this.inputSize) {
            return this.input[this.position];
        }
        return -1;
    }

    @Override
    public String peek(int length) {
        if (this.position + length - 1 < this.inputSize) {
            char[] result = new char[length];
            for (int i = 0; i < length; ++i) {
                result[i] = this.input[this.position + i];
            }
            return new String(result);
        }
        return null;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public int getInputSize() {
        return this.inputSize;
    }

    @Override
    public void setPosition(int position) {
        this.position = position < 0 ? 0 : position;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            InputBuffer b = (InputBuffer)object;
            return this.input == b.input && this.position == b.position;
        }
        return false;
    }

    public int hashCode() {
        int start = 17;
        int mult = 37;
        int result = 17;
        if (this.input != null) {
            for (char c : this.input) {
                result = 37 * (result + c);
            }
        }
        result = 37 * result + this.position;
        return Math.abs(result);
    }

    public String toString() {
        return "InputBuffer{input=" + Arrays.toString(this.input) + ", position=" + this.position + ", inputSize=" + this.inputSize + "}";
    }
}

